/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.LegacyRoleBasedDocumentAuthorization;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;

public class DlsFlsProcessedConfig {
    private static final Logger log = LogManager.getLogger(DlsFlsProcessedConfig.class);
    public static final DlsFlsProcessedConfig DEFAULT = new DlsFlsProcessedConfig(DlsFlsConfig.DEFAULT, null, null, null);
    private final DlsFlsConfig dlsFlsConfig;
    private final LegacyRoleBasedDocumentAuthorization documentAuthorization;
    private final boolean enabled;
    private final boolean validationErrorsPresent;
    private final String validationErrorDescription;
    private final String uniqueValidationErrorToken;

    DlsFlsProcessedConfig(DlsFlsConfig dlsFlsConfig, LegacyRoleBasedDocumentAuthorization documentAuthorization, ValidationErrors rolesValidationErrors, ValidationErrors rolesMappingValidationErrors) {
        this.dlsFlsConfig = dlsFlsConfig;
        this.documentAuthorization = documentAuthorization;
        this.enabled = dlsFlsConfig.getEnabledImpl() != DlsFlsConfig.Impl.FLX;
        this.validationErrorsPresent = rolesValidationErrors != null && rolesValidationErrors.hasErrors() || rolesMappingValidationErrors != null && rolesMappingValidationErrors.hasErrors();
        this.uniqueValidationErrorToken = UUID.randomUUID().toString();
        this.validationErrorDescription = this.describeValidationErrors(this.uniqueValidationErrorToken, rolesValidationErrors, rolesMappingValidationErrors);
    }

    static DlsFlsProcessedConfig createFrom(ConfigMap configMap, ComponentState componentState, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        try {
            SgDynamicConfiguration dlsFlsConfigContainer = configMap.get(DlsFlsConfig.TYPE);
            DlsFlsConfig dlsFlsConfig = null;
            LegacyRoleBasedDocumentAuthorization documentAuthorization = null;
            dlsFlsConfig = dlsFlsConfigContainer != null && dlsFlsConfigContainer.getCEntry("default") != null ? (DlsFlsConfig)dlsFlsConfigContainer.getCEntry("default") : DlsFlsConfig.DEFAULT;
            ValidationErrors rolesValidationErrors = null;
            if (dlsFlsConfig.getEnabledImpl() != DlsFlsConfig.Impl.FLX) {
                SgDynamicConfiguration roleConfig = configMap.get(CType.ROLES);
                rolesValidationErrors = roleConfig.getValidationErrors();
                documentAuthorization = new LegacyRoleBasedDocumentAuthorization((SgDynamicConfiguration<Role>)roleConfig, resolver, clusterService);
                componentState.setState(ComponentState.State.INITIALIZED);
            } else {
                componentState.setState(ComponentState.State.DISABLED);
            }
            ValidationErrors rolesMappingValidationErrors = Optional.ofNullable(configMap.get(CType.ROLESMAPPING)).map(mappings -> mappings.getValidationErrors()).orElse(null);
            return new DlsFlsProcessedConfig(dlsFlsConfig, documentAuthorization, rolesValidationErrors, rolesMappingValidationErrors);
        }
        catch (Exception e) {
            log.error("Error while updating DLS/FLS config", (Throwable)e);
            componentState.setFailed((Throwable)e);
            return DEFAULT;
        }
    }

    public DlsFlsConfig getDlsFlsConfig() {
        return this.dlsFlsConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public LegacyRoleBasedDocumentAuthorization getDocumentAuthorization() {
        return this.documentAuthorization;
    }

    private static String describeConfigurationErrors(Map<String, Collection<ValidationError>> validationErrors, String configType) {
        if (validationErrors.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("The following validation errors found in SearchGuard ").append(configType).append(" definitions. ");
        for (Map.Entry<String, Collection<ValidationError>> error : validationErrors.entrySet()) {
            String errorDescription = error.getValue().stream().map(ValidationError::toValidationErrorsOverviewString).collect(Collectors.joining(", "));
            stringBuilder.append("Incorrect value is pointed out by the expression '").append(error.getKey()).append("' and is related to the following error message '").append(errorDescription).append("'. ");
        }
        return stringBuilder.toString();
    }

    private String describeValidationErrors(String uniqueToken, ValidationErrors rolesErrors, ValidationErrors rolesMappingsErrors) {
        Map rolesValidationErrors = Optional.ofNullable(rolesErrors).filter(ValidationErrors::hasErrors).map(ValidationErrors::getErrors).orElseGet(Collections::emptyMap);
        Map mappingsValidationErrors = Optional.ofNullable(rolesMappingsErrors).filter(ValidationErrors::hasErrors).map(ValidationErrors::getErrors).orElseGet(Collections::emptyMap);
        if (!rolesValidationErrors.isEmpty() || !mappingsValidationErrors.isEmpty()) {
            String rolesErrorDescription = DlsFlsProcessedConfig.describeConfigurationErrors(rolesValidationErrors, "roles");
            String mappingsErrorDescription = DlsFlsProcessedConfig.describeConfigurationErrors(mappingsValidationErrors, "roles mapping");
            String message = rolesErrorDescription + mappingsErrorDescription + "Please correct the configuration to unblock access to the system. (" + uniqueToken + ")";
            log.error(message);
            return message;
        }
        return null;
    }

    public boolean containsValidationError() {
        return this.validationErrorsPresent;
    }

    public String getValidationErrorDescription() {
        return this.validationErrorDescription;
    }

    public String getUniqueValidationErrorToken() {
        return this.uniqueValidationErrorToken;
    }
}

